<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function searches()
    {
        return $this->hasMany('Search');
    }

    public function favourites()
    {
        return $this->hasMany('Favourite');
    }

    public function listings()
    {
        return $this->hasMany('Vehicle');
    }

    public function profile()
    {
        return $this->belongsTo('Profile');
    }

    public function enquiries()
    {
        return $this->hasMany('Enquiry');
    }

    public function abuseReports()
    {
        return $this->hasMany('AbuseReport');
    }

}